%------------------------------------------------------------------------------
% File     : SEU797^2 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Set Theory
% Problem  : More about Functions - Images of Functions
% Version  : Especial > Reduced > Especial.
% English  : (! A:i.! f:i>i.! x:i.(? y:i.in y A & x = f y) ->
%            in x (image1 A (^ y:i.f y)))

% Refs     : [Bro08] Brown (2008), Email to G. Sutcliffe
% Source   : [Bro08]
% Names    : ZFC299l [Bro08]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.11 v7.2.0, 0.00 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.00 v6.1.0, 0.14 v5.5.0, 0.33 v5.4.0, 0.40 v5.3.0, 0.60 v5.2.0, 0.40 v4.1.0, 0.33 v3.7.0
% Syntax   : Number of formulae    :    5 (   0 unit;   3 type;   1 defn)
%            Number of atoms       :   29 (   3 equality;  18 variable)
%            Maximal formula depth :   10 (   6 average)
%            Number of connectives :   21 (   0   ~;   0   |;   2   &;  16   @)
%                                         (   1 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    7 (   7   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   3   :;   0   =)
%            Number of variables   :   10 (   0 sgn;   6   !;   2   ?;   2   ^)
%                                         (  10   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : http://mathgate.info/detsetitem.php?id=420
%          : 
%------------------------------------------------------------------------------
thf(in_type,type,(
    in: $i > $i > $o )).

thf(image1_type,type,(
    image1: $i > ( $i > $i ) > $i )).

thf(image1Equiv_type,type,(
    image1Equiv: $o )).

thf(image1Equiv,definition,
    ( image1Equiv
    = ( ! [A: $i,Xf: $i > $i,Xx: $i] :
          ( ( in @ Xx
            @ ( image1 @ A
              @ ^ [Xy: $i] :
                  ( Xf @ Xy ) ) )
        <=> ? [Xy: $i] :
              ( ( in @ Xy @ A )
              & ( Xx
                = ( Xf @ Xy ) ) ) ) ) )).

thf(image1I,conjecture,
    ( image1Equiv
   => ! [A: $i,Xf: $i > $i,Xx: $i] :
        ( ? [Xy: $i] :
            ( ( in @ Xy @ A )
            & ( Xx
              = ( Xf @ Xy ) ) )
       => ( in @ Xx
          @ ( image1 @ A
            @ ^ [Xy: $i] :
                ( Xf @ Xy ) ) ) ) )).

%------------------------------------------------------------------------------
